#adjust this to the folder that contains data files
setwd("/Users/ding/Documents/R/Main")

# transfer all the output to a file.
sink("output_analysisII_MainResults", split = "TRUE")
R.version.string
sessionInfo()
# for more information, use R.Version()

cat("\n###############################################################################\n")
cat("\n# Analysis for the paper for International Journal of Human-Computer Studies: Virtual reality negotiation training system with exposure to simulated thoughts and conversations: Design and evaluation\n")
cat("\n# 2018 TUDelft\n")
cat("\n# Output file: output_analysisII_MainResults.txt will be created \n")
cat("\n# Author: Ding Ding \n")
cat("\n# required datafile from Data preparation I&II\n")
cat("\n# - DemographyData.csv\n")
cat("\n# - NegoKnowledge_CodingSamples.csv\n")
cat("\n# - SE_With aLL sessions.csv\n")
cat("\n# - SE_CompareWL&EX.csv\n")
cat("\n# - SE_WL.csv\n")
cat("\n# - SE_EX.csv\n")
cat("\n# - SA_CompareWL&EX.csv\n")
cat("\n# - SA_WL.csv\n")
cat("\n# - SA_EX.csv\n")
cat("\n# - NegoF_CompareWL&EX.csv\n")
cat("\n# - NegoF_ALL.csv\n")
cat("\n# - NegoF_WL.csv\n")
cat("\n# - NegoF_EX.csv\n")
cat("\n# - NegoResult_CompareWL&EX.csv\n")
cat("\n# - NegoResult_ALL.csv\n")
cat("\n# - NegoResult_WL.csv\n")
cat("\n# - NegoResult_EX.csv\n")
cat("\n# - NegoKnowledge_CompareWL&EX.csv\n")
cat("\n# - NegoKnowledge_ALL.csv\n")
cat("\n# - NegoKnowledge_WL.csv\n")
cat("\n# - NegoKnowledge_EX.csv\n")
cat("\n# - Utility.csv\n")

####################### Functions #######################
testbetween <-function(sample1,sample2)
{
  # x integer data being tested
  # g group
  
  # convert group into factor:
  #g <- factor(g)
  x<-c(sample1, sample2)
  g<-as.factor(c(rep(1, length(sample1)), rep(2, length(sample2))))
  
  l<-leveneTest(x,g)
  if (l$`Pr(>F)`[1]<.05)
  {
    cat("\nLevene's test shows sign difference between the group variance, therefore  Welch Two Sample t-test conducted\n")
    print(t.test(x~g, na.rm = TRUE,var.equal = FALSE))
  } else
  {
    cat("\nLevene's test shows no sign difference between the group variance, therefore  Two Sample t-test conducted\n")
    print(t.test(x~g, na.rm = TRUE,var.equal = TRUE))
  }
}

cat("\n#################### Demographic data ####################\n")
cat("\n# File with all Demographic information of participants\n")
cat("\n# Data originally obtained from the file: DemographyData.csv\n")
cat("\n# data fields\n")
cat("\n# - ParticipantInfo\n")
cat("\n# - ParticipantInfoDirectWS: information of the participants joined the experiment directly as with self-motivation group\n")
cat("\n# - ParticipantInfoDirectWOS: information of the participants joined the experiment directly as without self-motivation group\n")
cat("\n# - ParticipantInfoDirectEX: information of the participants joined the experiment directly \n")
cat("\n# - ParticipantInfoWL: information of the participants joined the waitinglist group \n")
cat("\n# - ParticipantInfoInterventionWS: information of all the participants finally join the intervention  as with self-motivation group\n")
cat("\n# - ParticipantInfoInterventionWOS: information of all the participants finally join the intervention  as without self-motivation group\n")

ParticipantInfo <- read.csv("DemographyData.csv", header = TRUE)
ParticipantInfoDirectWS<-subset(ParticipantInfo,Group=="EWS" )
ParticipantInfoDirectWOS<-subset(ParticipantInfo,Group=="EWOS")
ParticipantInfoWL<-subset(ParticipantInfo,Group=="WLWOS" |Group=="WLWS")
ParticipantInfoDirectEX<-subset(ParticipantInfo,Group=="EWS" |Group=="EWOS")
ParticipantInfoInterventionWS<-subset(ParticipantInfo,Group=="WLWS" |Group=="EWS" )
ParticipantInfoInterventionWOS<-subset(ParticipantInfo,Group=="WLWOS" |Group=="EWOS")

cat("\n#################### refer to 4.1 Participants ####################\n")
summary(ParticipantInfo) #
describe(ParticipantInfo$Age) #

cat("\n#################### refer to 4.4.1 Data preparation ####################\n")
cat("\n###### refer to table 3:Demographic characteristics and pre-measurements ###### \n")
cat("\n### Age ####\n")
cat("\n## Waitlist vs Training\n")
cat("\n# 1.Waitlist\n")
describe(ParticipantInfoWL$Age)
cat("\n# 2.Training\n")
describe(ParticipantInfoDirectEX$Age)
testbetween(ParticipantInfoWL$Age,ParticipantInfoDirectEX$Age)

cat("\n## Training with self-motivation vs without self-motivation\n")
cat("\n# 1.Training with self-motivation\n")
describe(ParticipantInfoInterventionWS$Age)
cat("\n# 2.Training without self-motivation\n")
describe(ParticipantInfoInterventionWOS$Age)
testbetween(ParticipantInfoInterventionWS$Age,ParticipantInfoInterventionWOS$Age)

cat("\n### Gender ###\n")
cat("\n## Waitlist vs Training\n")
cat("\n# 1.Waitlist\n")
count(ParticipantInfoWL,Gender)
WL_gender<-count(ParticipantInfoWL,Gender)
cat("\n# 2.Training\n")
count(ParticipantInfoDirectEX,Gender)
EX_gender<-count(ParticipantInfoDirectEX,Gender)
gender_EXWL<-merge(EX_gender,WL_gender, by=c("Gender"))
gender<-data.frame(EX_gender$n,WL_gender$n)
chisq.test(gender_EXWL[c(2,3)],correct = F)

cat("\n# Training with self-motivation vs without self-motivation\n")
ParticipantInfoInterventionWS$Gender<-factor(ParticipantInfoInterventionWS$Gender)
ParticipantInfoInterventionWOS$Gender<-factor(ParticipantInfoInterventionWOS$Gender)
cat("\n# 1.Training with self-motivation\n")
count(ParticipantInfoInterventionWS,Gender)
WS_gender<-count(ParticipantInfoInterventionWS,Gender)
cat("\n# 2.Training without self-motivation\n")
count(ParticipantInfoInterventionWOS,Gender)
WOS_gender<-count(ParticipantInfoInterventionWOS,Gender)
gender_WSWOS<-merge(WS_gender,WOS_gender, by=c("Gender"))
chisq.test(gender_WSWOS[c(2,3)],correct = F)

cat("\n### Virtual Reality Experience ###\n")
cat("\n## Waitlist vs Training\n")
cat("\n# 1.Waitlist\n")
count(ParticipantInfoWL,VRexperience)
WL_VR<-count(ParticipantInfoWL,VRexperience)
cat("\n# 2.Training\n")
count(ParticipantInfoDirectEX,VRexperience)
EX_VR<-count(ParticipantInfoDirectEX,VRexperience)
VR_WLEX<-merge(WL_VR,EX_VR, by=c("VRexperience"))
chisq.test(VR_WLEX[c(2,3)],correct = F) # chisq.test(VR_WLEX[c(2,3)],simulate.p.value = TRUE)

cat("\n## Training with self-motivation vs without self-motivation\n")
cat("\n# 1.Training with self-motivation\n")
count(ParticipantInfoInterventionWS,VRexperience)
WS_VR<-count(ParticipantInfoInterventionWS,VRexperience)
cat("\n# 2.Training without self-motivation\n")
count(ParticipantInfoInterventionWOS,VRexperience)
WOS_VR<-count(ParticipantInfoInterventionWOS,VRexperience)
VR_WSWOS<-merge(WS_VR,WOS_VR, by=c("VRexperience"))
chisq.test(VR_WSWOS[c(2,3)],correct = F) # chisq.test(VR_WSWOS[c(2,3)],simulate.p.value = TRUE)

cat("\n#################### Self-efficacy ####################\n")
cat("\n#################### Compare the self-efficacy data of participants between waitinglist and experiment group\n")
cat("\n# File with the self-efficacy data of waitinglist and experiment group\n")
cat("\n# Data originally obtained from the file SE_CompareWL&EX.csv\n")
cat("\n# data fields\n")
cat("\n#1 ID: Participants ID\n")
cat("\n#2 Group: waitinglist or experiment group\n")
cat("\n#3 Session: Pre or Post\n")
cat("\n#4 Score: the self-efficacy data\n")

SE_WLwithEX <- read.csv("SE_CompareWL&EX.csv", header = TRUE)
SE_WLwithEX$Session<-factor(SE_WLwithEX$Session,levels = c("Pre","Post"))
SE_Waitinglist <- read.csv("SE_WL.csv", header = TRUE)
SE_Experiment <- read.csv("SE_EX.csv", header = TRUE)
SE_Experiment_WS<-subset(SE_Experiment,Group=="EWS" )
SE_Experiment_WOS<-subset(SE_Experiment,Group=="EWOS" )

cat("\n#################### Compare the self-efficacy data of participants of training with self-motivation and without self-motivation group\n")
cat("\n# File with the self-efficacy data of all training sessions\n")
cat("\n# Data originally obtained from the file SE_With aLL sessions.csv\n")
cat("\n# data fields\n")
cat("\n#1 SE:  Self-efficacy data measured before the training session (Pre-measurement data)\n")
cat("\n#2 SE1: Self-efficacy data measured after the first training session \n")
cat("\n#3 SE2: Self-efficacy data measured after the second training session\n")
cat("\n#4 SE3: Self-efficacy data measured after the third training session (Post-measurement data)\n")
cat("\n#5 SE_follow: Self-efficacy data measured two weeks after all the training sessions (Follow-up measurement data)\n")

SE_AllSessions <- read.csv("SE_With aLL sessions.csv", header = TRUE)
SE_AllSessions$SE<-as.numeric(as.character(SE_AllSessions$SE))
SE_AllSessions$SE1<-as.numeric(as.character(SE_AllSessions$SE1))
SE_AllSessions$SE2<-as.numeric(as.character(SE_AllSessions$SE2))
SE_AllSessions$SE3<-as.numeric(as.character(SE_AllSessions$SE3))
SE_AllWS<-subset(SE_AllSessions,Group=="WS")
SE_AllWOS<-subset(SE_AllSessions,Group=="WOS")

cat("\n################# Negotiation knowledge ################# \n") 
cat("\n# File with the negotiation knowledge of participants from waitinglist and training group\n")
cat("\n# Data originally obtained from the file NegoKnowledge_CompareWL&EX.csv\n")
cat("\n#1 ID: Participants ID\n") 
cat("\n#2 Group: waitinglist or experiment group(with self-motivation or without self-motivation)\n") 
cat("\n#3 Session: Pre or Post\n") 
cat("\n#4 Score: the negotiation knowledge test data\n") 

NegoKnowledge_WLwithEX <- read.csv("NegoKnowledge_CompareWL&EX.csv", header = TRUE)
NegoKnowledge_WLwithEX$Session<-factor(NegoKnowledge_WLwithEX$Session,levels = c("Pre","Post"))
NegoKnowledge_Waitinglist <- read.csv("NegoKnowledge_WL.csv", header = TRUE)
NegoKnowledge_Experiment <- read.csv("NegoKnowledge_EX.csv", header = TRUE)

cat("\n## Compare the negotiation knowledge of participants from training with self-motivation and without self-motivation group\n")
cat("\n# Data originally obtained from the file NegoKnowledge_ALL.csv\n")
cat("\n#1 ID: Participants ID\n")
cat("\n#2 Pre: pre-measurement data\n")
cat("\n#3 Post: post-measurement data\n")
cat("\n#4 FollowUp: followUp-measurement data\n")
cat("\n#5 Group: with self-motivation or without self-motivation\n")
NegoKnowledge_AllSessions <- read.csv("NegoKnowledge_ALL.csv", header = TRUE)
NegoKnowledge_AllSessions$Pre<-as.numeric(as.character(NegoKnowledge_AllSessions$Pre))
NegoKnowledge_AllSessions$Post<-as.numeric(as.character(NegoKnowledge_AllSessions$Post))
NegoKnowledge_AllSessions$FollowUp<-as.numeric(as.character(NegoKnowledge_AllSessions$FollowUp))
NegoKnowledge_AllWS<-subset(NegoKnowledge_AllSessions,Group=="WS")
NegoKnowledge_AllWOS<-subset(NegoKnowledge_AllSessions,Group=="WOS")

cat("\n################# Negotiation behaviour and performance #################\n")

cat("\n####### Negotiation Frequency ######\n")
cat("\n# File with the negotiation frequency data of participants from waitinglist and training group\n")
cat("\n# Data originally obtained from the file NegoF_CompareWL&EX.csv\n")
cat("\n#1 ID: Participants ID\n")
cat("\n#2 Group: waitinglist or experiment group(with self-motivation or without self-motivation)\n")
cat("\n#3 Session: Pre or Post\n")
cat("\n#4 Score: the negotiation Frequency data\n")

NegoF_WLwithEX <- read.csv("NegoF_CompareWL&EX.csv", header = TRUE)
cat("\n## Compare waitinglist and training group\n") 
NegoF_Waitinglist <- read.csv("NegoF_WL.csv", header = TRUE)
NegoF_Experiment <- read.csv("NegoF_EX.csv", header = TRUE)

cat("\n#################### Compare the negotiation frequency data of participants of training with self-motivation and without self-motivation group\n")
cat("\n# File with the negotiation frequency data of participants from both training with self-motivation and  without self-motivation group\n")
cat("\n# Data originally obtained from the file NegoF_ALL.csv\n")
cat("\n#1 ID: Participants ID\n")
cat("\n#2 Pre: pre-measurement data\n")
cat("\n#3 Post: post-measurement data\n")
cat("\n#4 FollowUp: followUp-measurement data\n")
cat("\n#5 Group: with self-motivation or without self-motivation\n")

NegoF_AllSessions <- read.csv("NegoF_ALL.csv", header = TRUE)
NegoF_AllSessions$Pre<-as.numeric(as.character(NegoF_AllSessions$Pre))
NegoF_AllSessions$Post<-as.numeric(as.character(NegoF_AllSessions$Post))
NegoF_AllSessions$FollowUp<-as.numeric(as.character(NegoF_AllSessions$FollowUp))
NegoF_AllWS<-subset(NegoF_AllSessions,Group=="WS")
NegoF_AllWOS<-subset(NegoF_AllSessions,Group=="WOS")

cat("\n####### Negotiation satisfaction #######\n")
cat("\n# Compare negotiation satisfaction data of participants between waitinglist and training\n")
cat("\n# File with the negotiation frequency data of participants from both waitinglist or experiment group\n")
cat("\n# Data originally obtained from the file SA_CompareWL&EX.csv\n")
cat("\n#1 ID: Participants ID\n")
cat("\n#2 Group: waitinglist or experiment group (with self-motivation or without self-motivation)\n")
cat("\n#3 Session: Pre or Post\n")
cat("\n#4 Score: the negotiation satisfaction data\n")

SA_WLwithEX <- read.csv("SA_CompareWL&EX.csv", header = TRUE)
SA_WLwithEX$Session<-factor(SA_WLwithEX$Session,levels = c("Pre","Post"))
SA_Waitinglist <- read.csv("SA_WL.csv", header = TRUE)
SA_Experiment <- read.csv("SA_EX.csv", header = TRUE)
SA_Experiment_WS<-subset(SA_Experiment,Group=="EWS" )
SA_Experiment_WOS<-subset(SA_Experiment,Group=="EWOS" )

cat("\n## Compare negotiation satisfaction data of participants between with self-motivation and without self-motivation\n")
cat("\n# File with the negotiation satisfaction data of participants from both training with self-motivation and  without self-motivation group\n")
cat("\n# Data originally obtained from the file SA_ALL.csv\n")
cat("\n#1 ID: Participants ID\n")
cat("\n#2 Pre: pre-measurement data\n")
cat("\n#3 Post: post-measurement data\n")
cat("\n#4 FollowUp: followUp-measurement data\n")
cat("\n#5 Group: with self-motivation or without self-motivation\n")
SA_AllSessions <- read.csv("SA_ALL.csv", header = TRUE)
SA_AllSessions$Pre<-as.numeric(as.character(SA_AllSessions$Pre))
SA_AllSessions$Post<-as.numeric(as.character(SA_AllSessions$Post))
SA_AllSessions$FollowUp<-as.numeric(as.character(SA_AllSessions$FollowUp))
SA_AllWS<-subset(SA_AllSessions,Group=="WS")
SA_AllWOS<-subset(SA_AllSessions,Group=="WOS")

cat("\n################# Negotiation Result #################\n")
cat("\n# Compare negotiation result data of participants between waitinglist and training\n")
cat("\n#1 ID: Participants ID\n")
cat("\n#2 Group: Waitinglist or experiment group (with self-motivation or without self-motivation)\n")
cat("\n#3 Session: Pre or Post\n")
cat("\n#4 Score: the negotiation result data\n")
NegoResult_WLwithEX <- read.csv("NegoResult_CompareWL&EX.csv", header = TRUE)
NegoResult_WLwithEX$Session<-factor(NegoResult_WLwithEX$Session,levels = c("Pre","Post"))
NegoResult_Waitinglist <- read.csv("NegoResult_WL.csv", header = TRUE)
NegoResult_Experiment <- read.csv("NegoResult_EX.csv", header = TRUE)

cat("\n## Compare negotiation result data of participants between without self-motivation and with self-motivation group\n")
cat("\n#1 ID: Participants ID\n")
cat("\n#2 Pre: pre-measurement data\n")
cat("\n#3 Post: post-measurement data\n")
cat("\n#4 FollowUp: followUp-measurement data\n")
cat("\n#5 Group: with self-motivation or without self-motivation\n")
NegoResult_AllSessions <- read.csv("NegoResult_ALL.csv", header = TRUE)
NegoResult_AllSessions$Pre<-as.numeric(as.character(NegoResult_AllSessions$Pre))
NegoResult_AllSessions$Post<-as.numeric(as.character(NegoResult_AllSessions$Post))
NegoResult_AllSessions$FollowUp<-as.numeric(as.character(NegoResult_AllSessions$FollowUp))
NegoResult_AllWS<-subset(NegoResult_AllSessions,Group=="WS")
NegoResult_AllWOS<-subset(NegoResult_AllSessions,Group=="WOS")


cat("\n#################### Compare the pre-measurement data of participants between waitinglist and training group\n")
cat("\n#################### refer to 4.4.1 Data preparation ####################\n")
cat("\n###### refer to table 3:Demographic characteristics and pre-measurements ###### \n")

## Self-efficacy
cat("\n## Self-efficacy: Waitlist vs Training\n")
cat("\n# 1.Waitlist\n")
describe(SE_Waitinglist$Pre) #table 3
cat("\n# 2.Training\n")
describe(SE_Experiment$Pre) #table 3 
testbetween(SE_Waitinglist$Pre,SE_Experiment$Pre) # table 3
cat("\n## Self-efficacy: Training with self-motivation vs without self-motivation\n")
cat("\n# 1.Training with self-motivation\n")
describe(SE_AllWS$SE) #table 3
cat("\n# 2.Training without self-motivation\n")
describe(SE_AllWOS$SE) #table 3
testbetween(SE_AllWOS$SE,SE_AllWS$SE) #table 3

## Negotiation knowledge
cat("\n## Negotiation knowledge: Waitlist vs Training\n")
cat("\n# 1.Waitlist\n")
describe(NegoKnowledge_Waitinglist$Pre) #table 3
cat("\n# 2.Training\n")
describe(NegoKnowledge_Experiment$Pre) #table 3
testbetween(NegoKnowledge_Experiment$Pre,NegoKnowledge_Waitinglist$Pre) #table 3
cat("\n## Negotiation knowledge:Training with self-motivation vs without self-motivation\n")
cat("\n# 1.Training with self-motivation\n")
describe(NegoKnowledge_AllWS$Pre) #table 3
cat("\n# 1.Training without self-motivation\n")
describe(NegoKnowledge_AllWOS$Pre) #table 3
testbetween(NegoKnowledge_AllWS$Pre,NegoKnowledge_AllWOS$Pre)

## Negotiation frequency
cat("\n## Negotiation frequency: Waitlist vs Training\n")
cat("\n# 1.Waitlist\n")
describe(NegoF_Waitinglist$Pre) #table 3
cat("\n# 2.Training\n")
describe(NegoF_Experiment$Pre) #table 3
g = factor(c(rep("NegoF_Waitinglist$Pre", length(NegoF_Waitinglist$Pre)), rep("NegoF_Experiment$Pre", length(NegoF_Experiment$Pre))))
v = c(NegoF_Waitinglist$Pre, NegoF_Experiment$Pre)
wilcox_test(v~g,distribution="exact")
wilcox_WLEX_NegoFPre<-wilcox_test(v~g,distribution="exact")
cat("\n# p value:")
pvalue(wilcox_WLEX_NegoFPre) #table 3
cat("\n# The standardised z statistic Z:")
wilcox_WLEX_NegoFPre@statistic@teststatistic[["NegoF_Experiment$Pre"]]#table 3

cat("\n## Negotiation frequency: Training with self-motivation vs without self-motivation\n")
cat("\n# 1.Training with self-motivation\n")
describe(NegoF_AllWS$Pre) #table 3
cat("\n# 1.Training without self-motivation\n")
describe(NegoF_AllWOS$Pre) #table 3
g = factor(c(rep("NegoF_AllWS$Pre", length(NegoF_AllWS$Pre)), rep("NegoF_AllWOS$Pre", length(NegoF_AllWOS$Pre))))
v = c(NegoF_AllWS$Pre, NegoF_AllWOS$Pre)
wilcox_test(v~g,distribution="exact")
wilcox_WSWOS_NegoFPre<-wilcox_test(v~g,distribution="exact")
cat("\n# p value:")
pvalue(wilcox_WSWOS_NegoFPre) #table 3
cat("\n# The standardised z statistic Z:")
wilcox_WSWOS_NegoFPre@statistic@teststatistic[["NegoF_AllWOS$Pre"]]#table 3

## Negotiation satisfaction
cat("\n## Negotiation satisfaction: Waitlist vs Training\n")
cat("\n# 1.Waitlist\n")
describe(SA_Waitinglist$Pre) #table 3
cat("\n# 2.Training\n")
describe(SA_Experiment$Pre)  #table 3
g = factor(c(rep("SA_Waitinglist$Pre", length(SA_Waitinglist$Pre)), rep("SA_Experiment$Pre", length(SA_Experiment$Pre))))
v = c(SA_Waitinglist$Pre, SA_Experiment$Pre)
wilcox_test(v~g,distribution="exact")
wilcox_comparePre_SA<-wilcox_test(v~g,distribution="exact")
cat("\n# p value:")
pvalue(wilcox_comparePre_SA) #table 3
cat("\n# The standardised z statistic Z:")
wilcox_comparePre_SA@statistic@teststatistic[["SA_Experiment$Pre"]]#table 3

cat("\n## Negotiation satisfaction: Training with self-motivation vs without self-motivation\n")
cat("\n# 1.Training with self-motivation\n")
describe(SA_AllWS$Pre) # table 3
cat("\n# 2.Training without self-motivation\n")
describe(SA_AllWOS$Pre) # table 3
g = factor(c(rep("SA_AllWS$Pre", length(SA_AllWS$Pre)), rep("SA_AllWOS$Pre", length(SA_AllWOS$Pre))))
v = c(SA_AllWS$Pre, SA_AllWOS$Pre)
wilcox_test(v~g,distribution="exact")
wilcox_comparePre_SA<-wilcox_test(v~g,distribution="exact")
cat("\n# p value:")
pvalue(wilcox_comparePre_SA) #table 3
cat("\n# The standardised z statistic Z:")
wilcox_comparePre_SA@statistic@teststatistic[["SA_AllWOS$Pre"]]#table 3

## Negotiation Result
cat("\n## Negotiation Result: Waitlist vs Training\n")
cat("\n# 1.Waitlist\n")
describe(NegoResult_Waitinglist$Pre) #table 3
cat("\n# 2.Training\n")
describe(NegoResult_Experiment$Pre) #table 3
g = factor(c(rep("NegoResult_Waitinglist$Pre", length(NegoResult_Waitinglist$Pre)), rep("NegoResult_Experiment$Pre", length(NegoResult_Experiment$Pre))))
v = c(NegoResult_Waitinglist$Pre, NegoResult_Experiment$Pre)
wilcox_test(v~g,distribution="exact")
wilcox_WLEX_NegoResultPre<-wilcox_test(v~g,distribution="exact")
cat("\n# p value:")
pvalue(wilcox_WLEX_NegoResultPre) #table 3
cat("\n# The standardised z statistic Z:")
wilcox_WLEX_NegoResultPre@statistic@teststatistic[["NegoResult_Experiment$Pre"]]#table 3

cat("\n## Negotiation Result: Training with self-motivation vs without self-motivation\n")
cat("\n# 1.Training with self-motivation\n")
describe(NegoResult_AllWS$Pre) #table 3
cat("\n# 1.Training without self-motivation\n")
describe(NegoResult_AllWOS$Pre) #table 3
g = factor(c(rep("NegoResult_AllWS$Pre", length(NegoResult_AllWS$Pre)), rep("NegoResult_AllWOS$Pre", length(NegoResult_AllWOS$Pre))))
v = c(NegoResult_AllWS$Pre, NegoResult_AllWOS$Pre)
wilcox_test(v~g,distribution="exact")
wilcox_WSWOS_NegoResultPre<-wilcox_test(v~g,distribution="exact")
cat("\n# p value:")
pvalue(wilcox_WSWOS_NegoResultPre) #table 3
cat("\n# The standardised z statistic Z:")
wilcox_WSWOS_NegoResultPre@statistic@teststatistic[["NegoResult_AllWOS$Pre"]]#table 3

cat("\n#################### Inter-rater reliability coefficient\n")
cat("\n# File with the sample coding of negotiation knowledge video test from two coders\n")
cat("\n# Data orignally obtained from the file NegoKnowledge_CodingSamples.csv\n")
cat("\n# data fields\n")
cat("\n# - ID\n")
cat("\n# - CodeA\n")
cat("\n# - codeB\n")
CodingSamples_NegoKnowledge <- read.csv("NegoKnowledge_CodingSamples.csv", header = TRUE)
cat("\n#################### refer to 4.4.1 Data preparation ####################\n")
cat("\n###### refer to Reliability analysis of the coding of the negotiation knowledge test  ###### \n")
describe(CodingSamples_NegoKnowledge[2:3])
alpha(CodingSamples_NegoKnowledge[2:3]) 

cat("\n#################### Utility\n")
cat("\n# File with the utility data of the system from all participants\n")
cat("\n# Data orignally obtained from the file Utility.csv\n")
cat("\n# ID: Participants ID\n") 
cat("\n# Q1-Q7: the rating score of each item\n") 
cat("\n# Group: with self-motivation or without self-motivation\n") 

Utility_ALL <- read.csv("Utility.csv", header = TRUE)
Utility_Satisfaction<-Utility_ALL[,c(1:4,9)]
Utility_Effectiveness<-Utility_ALL[,c(1,5:9)]
cat("\n#################### refer to 4.4.1 Data preparation ####################\n")
cat("\n###### refer to Reliability analysis of the utility questionnaire  ###### \n")
alpha(Utility_Satisfaction[2:4])
alphaSatisfaction<-alpha(Utility_Satisfaction[2:4])
alpha(Utility_Effectiveness[2:5])
alphaEffectiveness<-alpha(Utility_Effectiveness[2:5])
cat("\n# Cronbach's alpha showed acceptable levels of reliability for the two subscales of the utility
    questionnaire, the satisfaction of the system (?? =",alphaSatisfaction$total$raw_alpha,") and usefulness of the system (?? =", alphaEffectiveness$total$raw_alpha, "), respectively.\n")

cat("\n#################### Compare the Pre-Post data of participants between waitinglist and training group\n")
cat("\n#################### refer to 5.1 Pre, post, and follow-up ####################\n")
cat("\n###### refer to table 4:Primary and secondary outcome measures comparison between pre and post measurement for the waitlist and training condition, and comparison between pre and post differences between the groups. ###### \n")

## Self-efficacy
cat("\n### Pre-Post of self-efficacy\n")

cat("\n## Waitlist vs Training\n")
cat("\n#  1. Waitlist\n")
testbetween(SE_Waitinglist$Post,SE_Waitinglist$Pre) #table 4
cat("\n# The effect size:")
cohensD(SE_Waitinglist$Post,SE_Waitinglist$Pre, method = "paired") #table 4
cat("\n# 2. Training\n")
testbetween(SE_Experiment$Post,SE_Experiment$Pre) #table 4
cat("\n# The effect size:")
cohensD(SE_Experiment$Post,SE_Experiment$Pre, method = "paired")#table 4
cat("\n# 3. Waitlist Vs Training\n")
testbetween(SE_Experiment$Post-SE_Experiment$Pre,SE_Waitinglist$Post-SE_Waitinglist$Pre) #table 4
cat("\n# The effect size:")
cohensD(SE_Experiment$Post-SE_Experiment$Pre,SE_Waitinglist$Post-SE_Waitinglist$Pre) #table 4

cat("\n## Training with self-motivation VS without self-motivation\n")
testbetween(SE_AllWS$SE3-SE_AllWS$SE,SE_AllWOS$SE3-SE_AllWOS$SE) # table 4
cat("\n# The effect size:")
cohensD(SE_AllWS$SE3-SE_AllWS$SE,SE_AllWOS$SE3-SE_AllWOS$SE)# table 4

## Negotiation knowledge
cat("\n### Pre-Post of Negotiation knowledge\n")

cat("\n## Waitlist vs Training\n")
cat("\n# 1. Waitlist\n") 
testbetween(NegoKnowledge_Waitinglist$Post,NegoKnowledge_Waitinglist$Pre)
cat("\n# The effect size:")
cohensD(NegoKnowledge_Waitinglist$Post,NegoKnowledge_Waitinglist$Pre,method="paired")
cat("\n# 2. Training\n") 
testbetween(NegoKnowledge_Experiment$Post,NegoKnowledge_Experiment$Pre)
cat("\n# The effect size:")
cohensD(NegoKnowledge_Experiment$Post,NegoKnowledge_Experiment$Pre,method="paired")
cat("\n# 3. Waitlist Vs training\n") 
testbetween(NegoKnowledge_Experiment$Post-NegoKnowledge_Experiment$Pre,NegoKnowledge_Waitinglist$Post-NegoKnowledge_Waitinglist$Pre)
cat("\n# The effect size:")
cohensD(NegoKnowledge_Experiment$Post-NegoKnowledge_Experiment$Pre,NegoKnowledge_Waitinglist$Post-NegoKnowledge_Waitinglist$Pre)

cat("\n## Training with self-motivation VS without self-motivation\n")
testbetween(NegoKnowledge_AllWS$Post-NegoKnowledge_AllWS$Pre,NegoKnowledge_AllWOS$Post-NegoKnowledge_AllWOS$Pre) #table 4
cat("\n# The effect size:")
cohensD(NegoKnowledge_AllWS$Post-NegoKnowledge_AllWS$Pre,NegoKnowledge_AllWOS$Post-NegoKnowledge_AllWOS$Pre) #table 4


## Negotiation Frequency

cat("\n### Pre-Post of Negotiation Frequency\n")

cat("\n## Waitlist vs Training\n")
cat("\n# 1. Waitinglist\n")  
wilcox_waitinglist_NegoF<-wilcox.test(NegoF_Waitinglist$Post,NegoF_Waitinglist$Pre,paired=TRUE)
cat("\n# p value:")
wilcox_waitinglist_NegoF$p.value #table 4
Zstat_waitinglist_NegoF<-qnorm(wilcox_waitinglist_NegoF$p.value/2)
cat("\n# The standardised z statistic Z:")
Zstat_waitinglist_NegoF #table 4
cat("\n# The effect size:")
abs(Zstat_waitinglist_NegoF)/sqrt(48) #table 4
cat("\n# 2. Training\n") 
wilcox_experiment_NegoF<-wilcox.test(NegoF_Experiment$Post,NegoF_Experiment$Pre,paired=TRUE)
cat("\n# p value:")
wilcox_experiment_NegoF$p.value #table 4
Zstat_experiment_NegoF<-qnorm(wilcox_experiment_NegoF$p.value/2)
cat("\n# The standardised z statistic Z:")
Zstat_experiment_NegoF #table 4
cat("\n# The effect size:")
abs(Zstat_experiment_NegoF)/sqrt(48) #table 4
cat("\n# 3. Waitlist Vs Training\n") 
NegoF_ExperimentChange<-NegoF_Experiment$Post-NegoF_Experiment$Pre
NegoF_WaitinglistChange<-NegoF_Waitinglist$Post-NegoF_Waitinglist$Pre
g = factor(c(rep("NegoF_ExperimentChange", length(NegoF_ExperimentChange)), rep("NegoF_WaitinglistChange", length(NegoF_WaitinglistChange))))
v = c(NegoF_ExperimentChange, NegoF_WaitinglistChange)
wilcox_test(v~g,distribution="exact")
wilcox_change_NegoF<-wilcox_test(v~g,distribution="exact")
cat("\n# p value:")
pvalue(wilcox_change_NegoF) #table 3
cat("\n# The standardised z statistic Z:")
Zstat_change_NegoF<-wilcox_change_NegoF@statistic@teststatistic[["NegoF_ExperimentChange"]]#table 3
Zstat_change_NegoF
cat("\n# The effect size:")
abs(Zstat_change_NegoF)/sqrt(48) #table 4

cat("\n## Training with self-motivation VS without self-motivation\n")
NegoF_WSChange<-NegoF_AllWS$Post-NegoF_AllWS$Pre
NegoF_WOSChange<-NegoF_AllWOS$Post-NegoF_AllWOS$Pre
g = factor(c(rep("NegoF_WSChange", length(NegoF_WSChange)), rep("NegoF_WOSChange", length(NegoF_WOSChange))))
v = c(NegoF_WSChange, NegoF_WOSChange)
wilcox_test(v~g,distribution="exact")
wilcox_WS<-wilcox_test(v~g,distribution="exact")
cat("\n# p value:")
pvalue(wilcox_WS) #table 3
cat("\n# The standardised z statistic Z:")
Zstat_WS<-wilcox_WS@statistic@teststatistic[["NegoF_WOSChange"]]#table 3
Zstat_WS
cat("\n# The effect size:")
abs(Zstat_WS)/sqrt(48) #table 4


## Negotiation satisfaction 

cat("\n### Pre-Post of Negotiation satisfaction\n")

cat("\n## Waitlist vs Training\n")
cat("\n# 1. Waitlist\n")
wilcox_waitinglist_SA<-wilcox.test(SA_Waitinglist$Post,SA_Waitinglist$Pre,paired=TRUE)#table 4
cat("\n# p value:")
wilcox_waitinglist_SA$p.value  #table 4
Zstat_waitinglist_SA<-qnorm(wilcox_waitinglist_SA$p.value/2)
cat("\n# The standardised z statistic Z:")
Zstat_waitinglist_SA  #table 4
cat("\n# The effect size:")
abs(Zstat_waitinglist_SA)/sqrt(48)  #table 4
cat("\n# 2. Training\n")
wilcox_expereiment_SA<-wilcox.test(SA_Experiment$Post,SA_Experiment$Pre,paired=TRUE)#table 4
cat("\n# p value:")
wilcox_expereiment_SA$p.value  #table 4
Zstat_expereiment_SA<-qnorm(wilcox_expereiment_SA$p.value/2)
cat("\n# The standardised z statistic Z:")
Zstat_expereiment_SA #table 4
cat("\n# The effect size:")
abs(Zstat_expereiment_SA)/sqrt(48) #table 4
cat("\n# 3. Waitlist Vs Training\n")
SA_ExperimentChange<-SA_Experiment$Post-SA_Experiment$Pre
SA_WaitinglistChange<-SA_Waitinglist$Post-SA_Waitinglist$Pre
g = factor(c(rep("SA_ExperimentChange", length(SA_ExperimentChange)), rep("SA_WaitinglistChange", length(SA_WaitinglistChange))))
v = c(SA_ExperimentChange, SA_WaitinglistChange)
wilcox_test(v~g,distribution="exact")
wilcox_change_SA<-wilcox_test(v~g,distribution="exact")
cat("\n# p value:")
pvalue(wilcox_change_SA) #table 3
cat("\n# The standardised z statistic Z:")
Zstat_change_SA<-wilcox_change_SA@statistic@teststatistic[["SA_ExperimentChange"]]#table 3
Zstat_change_SA
cat("\n# The effect size:")
abs(Zstat_change_SA)/sqrt(48) #table 4

cat("\n## Training with self-motivation VS without self-motivation\n")
SA_WSChange<-SA_AllWS$Post-SA_AllWS$Pre
SA_WOSChange<-SA_AllWOS$Post-SA_AllWOS$Pre
g = factor(c(rep("SA_WSChange", length(SA_WSChange)), rep("SA_WOSChange", length(SA_WOSChange))))
v = c(SA_WSChange, SA_WOSChange)
wilcox_test(v~g,distribution="exact")
wilcox_WSWOS_SA<-wilcox_test(v~g,distribution="exact")
cat("\n# p value:")
pvalue(wilcox_WSWOS_SA) #table 3
cat("\n# The standardised z statistic Z:")
Zstat_WSWOS_SA<-wilcox_WSWOS_SA@statistic@teststatistic[["SA_WOSChange"]]#table 3
Zstat_WSWOS_SA
cat("\n# The effect size:")
abs(Zstat_WSWOS_SA)/sqrt(48) #table 4



## Negotiation Result 
cat("\n### Pre-Post of Negotiation result\n")

cat("\n## Waitlist vs Training\n")
cat("\n# 1. Waitlist\n")
wilcox_Waitinglist_NegoResult<-wilcox.test(NegoResult_Waitinglist$Post,NegoResult_Waitinglist$Pre,paired=TRUE)
cat("\n# p value:")
wilcox_Waitinglist_NegoResult$p.value #table 4
Zstat_Waitinglist_NegoResult<-qnorm(wilcox_Waitinglist_NegoResult$p.value/2)
cat("\n# The standardised z statistic Z:")
Zstat_Waitinglist_NegoResult#table 4
cat("\n# The effect size:")
abs(Zstat_Waitinglist_NegoResult)/sqrt(48)#table 4
cat("\n# 2. Training\n")
wilcox_experiment_NegoResult<-wilcox.test(NegoResult_Experiment$Post,NegoResult_Experiment$Pre,paired=TRUE)
cat("\n# p value:")
wilcox_experiment_NegoResult$p.value #table 4
Zstat_experiment_NegoResult<-qnorm(wilcox_experiment_NegoResult$p.value/2)
cat("\n# The standardised z statistic Z:")
Zstat_experiment_NegoResult #table 4
cat("\n# The effect size:")
abs(Zstat_experiment_NegoResult)/sqrt(48)#table 4
cat("\n# 3. Waitlist Vs Training\n")
NegoResult_ExperimentChange<-NegoResult_Experiment$Post-NegoResult_Experiment$Pre
NegoResult_WaitinglistChange<-NegoResult_Waitinglist$Post-NegoResult_Waitinglist$Pre
g = factor(c(rep("NegoResult_ExperimentChange", length(NegoResult_ExperimentChange)), rep("NegoResult_WaitinglistChange", length(NegoResult_WaitinglistChange))))
v = c(NegoResult_ExperimentChange, NegoResult_WaitinglistChange)
wilcox_test(v~g,distribution="exact")
wilcox_change_NegoResult<-wilcox_test(v~g,distribution="exact")
cat("\n# p value:")
pvalue(wilcox_change_NegoResult) #table 3
cat("\n# The standardised z statistic Z:")
Zstat_change_NegoResult<-wilcox_change_NegoResult@statistic@teststatistic[["NegoResult_ExperimentChange"]]#table 3
Zstat_change_NegoResult
cat("\n# The effect size:")
abs(Zstat_change_NegoResult)/sqrt(48) #table 4


cat("\n## Training with self-motivation VS without self-motivation\n")
NegoResult_WSChange<-NegoResult_AllWS$Post-NegoResult_AllWS$Pre
NegoResult_WOSChange<-NegoResult_AllWOS$Post-NegoResult_AllWOS$Pre
g = factor(c(rep("NegoResult_WSChange", length(NegoResult_WSChange)), rep("NegoResult_WOSChange", length(NegoResult_WOSChange))))
v = c(NegoResult_WSChange, NegoResult_WOSChange)
wilcox_test(v~g,distribution="exact")
wilcox_WSWOS_NegoResult<-wilcox_test(v~g,distribution="exact")
cat("\n# p value:")
pvalue(wilcox_WSWOS_NegoResult) #table 3
cat("\n# The standardised z statistic Z:")
Zstat_WSWOS_NegoResult<-wilcox_WSWOS_NegoResult@statistic@teststatistic[["NegoResult_WOSChange"]]#table 3
Zstat_WSWOS_NegoResult
cat("\n# The effect size:")
abs(Zstat_WSWOS_NegoResult)/sqrt(48) #table 4



cat("\n#################### Compare the Pre-FollowUp data of participants for the training without self-motivation and training with self-motivation condition\n")
cat("\n#################### refer to 5.1 Pre, post, and follow-up ####################\n")
cat("\n###### refer to table 5: Primary and secondary outcome measures comparison between pre and follow-up measurement for the training without self-motivation and training with self-motivation condition, and comparison between pre and follow-up differences between the groups.###### \n")

## Self-efficacy
cat("\n### Pre-FollowUp of self-efficacy\n")
cat("\n## Training with self-motivation VS without self-motivation\n")
cat("\n# 1. Training without self-motivation\n")
testbetween(SE_AllWOS$SE_follow,SE_AllWOS$SE) # table 5
cat("\n# The effect size:")
cohensD(SE_AllWOS$SE_follow,SE_AllWOS$SE, method = "paired") # table 5
cat("\n# 2. Training with self-motivation\n")
testbetween(SE_AllWS$SE_follow,SE_AllWS$SE) # table 5
cat("\n# The effect size:")
cohensD(SE_AllWS$SE_follow,SE_AllWS$SE,method = "paired") # table 5
cat("\n# 3. Training with self-motivation VS Training without self-motivation\n")
testbetween(SE_AllWS$SE_follow-SE_AllWS$SE,SE_AllWOS$SE_follow-SE_AllWOS$SE) # table 5
cat("\n# The effect size:")
cohensD(SE_AllWS$SE_follow-SE_AllWS$SE,SE_AllWOS$SE_follow-SE_AllWOS$SE)# table 5

## Negotiation knowledge
cat("\n### Pre-FollowUp of Negotiation knowledge\n")
cat("\n## Training with self-motivation VS without self-motivation\n")
cat("\n# 1. Training without self-motivation\n")  
testbetween(NegoKnowledge_AllWOS$FollowUp,NegoKnowledge_AllWOS$Pre) #table 5
cohensD(NegoKnowledge_AllWOS$FollowUp,NegoKnowledge_AllWOS$Pre,method = "paired") #table 5
cat("\n# 2. Training with self-motivation\n") 
testbetween(NegoKnowledge_AllWS$FollowUp,NegoKnowledge_AllWS$Pre)  #table 5
cohensD(NegoKnowledge_AllWS$FollowUp,NegoKnowledge_AllWS$Pre,method = "paired") #table 5
cat("\n# 3. Training with self-motivation VS Training without self-motivation\n") 
testbetween(NegoKnowledge_AllWS$FollowUp-NegoKnowledge_AllWS$Pre,NegoKnowledge_AllWOS$FollowUp-NegoKnowledge_AllWOS$Pre) #table 5
cohensD(NegoKnowledge_AllWS$FollowUp-NegoKnowledge_AllWS$Pre,NegoKnowledge_AllWOS$FollowUp-NegoKnowledge_AllWOS$Pre) #table 5

## Negotiation Frequency 
cat("\n### Pre-FollowUp of Negotiation frequency \n")
cat("\n## Training with self-motivation VS without self-motivation\n")
cat("\n# 1. Training without self-motivation\n")
wilcox_WOS_follow<-wilcox.test(NegoF_AllWOS$FollowUp,NegoF_AllWOS$Pre,paired=TRUE)
cat("\n# p value:")
wilcox_WOS_follow$p.value #table 5
Zstat_WOS_follow<-qnorm(wilcox_WOS_follow$p.value/2)
cat("\n# The standardised z statistic Z:")
Zstat_WOS_follow #table 5
cat("\n# The effect size:")
abs(Zstat_WOS_follow)/sqrt(48) #table 5

cat("\n# 2. Training with self-motivation\n") 
wilcox_WS_follow<-wilcox.test(NegoF_AllWS$FollowUp,NegoF_AllWS$Pre,paired=TRUE)
cat("\n# p value:")
wilcox_WS_follow$p.value #table 5
Zstat_WS_follow<-qnorm(wilcox_WS_follow$p.value/2)
cat("\n# The standardised z statistic Z:")
Zstat_WS_follow #table 5
cat("\n# The effect size:")
abs(Zstat_WS_follow)/sqrt(48) #table 5

cat("\n# 3. Training with self-motivation VS Training without self-motivation\n")
NegoF_WSChange_follow<-NegoF_AllWS$FollowUp-NegoF_AllWS$Pre
NegoF_WOSChange_follow<-NegoF_AllWOS$FollowUp-NegoF_AllWOS$Pre
g = factor(c(rep("NegoF_WSChange_follow", length(NegoF_WSChange_follow)), rep("NegoF_WOSChange_follow", length(NegoF_WOSChange_follow))))
v = c(NegoF_WSChange_follow, NegoF_WOSChange_follow)
wilcox_test(v~g,distribution="exact")
wilcox_comparefollow_NegoF<-wilcox_test(v~g,distribution="exact")
cat("\n# p value:")
pvalue(wilcox_comparefollow_NegoF) #table 3
cat("\n# The standardised z statistic Z:")
Zstat_comparefollow_NegoF<-wilcox_comparefollow_NegoF@statistic@teststatistic[["NegoF_WOSChange_follow"]]#table 3
Zstat_comparefollow_NegoF
cat("\n# The effect size:")
abs(Zstat_comparefollow_NegoF)/sqrt(48) #table 4


## Negotiation satisfaction  
cat("\n### Pre-FollowUp of Negotiation satisfaction\n")
cat("\n## Training with self-motivation VS without self-motivation\n")
cat("# 1. Training without self-motivation\n")
wilcox_WOS_FollowSA<-wilcox.test(SA_AllWOS$FollowUp,SA_AllWOS$Pre,paired=TRUE)
cat("\n# p value:")
wilcox_WOS_FollowSA$p.value #table 5
Zstat_WOS_FollowSA<-qnorm(wilcox_WOS_FollowSA$p.value/2)
cat("\n# The standardised z statistic Z:")
Zstat_WOS_FollowSA #table 5
cat("\n# The effect size:")
abs(Zstat_WOS_FollowSA)/sqrt(48) #table 5

cat("# 2. Training with self-motivation\n")
wilcox_WS_FollowSA<-wilcox.test(SA_AllWS$FollowUp,SA_AllWS$Pre,paired=TRUE)
cat("\n# p value:")
wilcox_WS_FollowSA$p.value #table 5
Zstat_WS_FollowSA<-qnorm(wilcox_WS_FollowSA$p.value/2)
cat("\n# The standardised z statistic Z:")
Zstat_WS_FollowSA #table 5
cat("\n# The effect size:")
abs(Zstat_WS_FollowSA)/sqrt(48) #table 5

cat("# 3. Training with self-motivation VS Training without self-motivation\n")
SA_WSChange_follow<-SA_AllWS$FollowUp-SA_AllWS$Pre
SA_WOSChange_follow<-SA_AllWOS$FollowUp-SA_AllWOS$Pre
g = factor(c(rep("SA_WSChange_follow", length(SA_WSChange_follow)), rep("SA_WOSChange_follow", length(SA_WOSChange_follow))))
v = c(SA_WSChange_follow, SA_WOSChange_follow)
wilcox_test(v~g,distribution="exact")
wilcox_comparefollow_SA<-wilcox_test(v~g,distribution="exact")
cat("\n# p value:")
pvalue(wilcox_comparefollow_SA) #table 3
cat("\n# The standardised z statistic Z:")
Zstat_comparefollow_SA<-wilcox_comparefollow_SA@statistic@teststatistic[["SA_WOSChange_follow"]]#table 3
Zstat_comparefollow_SA
cat("\n# The effect size:")
abs(Zstat_comparefollow_SA)/sqrt(48) #table 4


## Negotiation Result  
cat("\n### Pre-FollowUp of Negotiation result\n")
cat("\n## Training with self-motivation VS without self-motivation\n")
cat("\n# 1. Training without self-motivation\n") 
wilcox_WOS_NegoResultFollow<-wilcox.test(NegoResult_AllWOS$FollowUp,NegoResult_AllWOS$Pre,paired=TRUE)
cat("\n# p value:")
wilcox_WOS_NegoResultFollow$p.value #table 5
Zstat_WOS_NegoResultFollow<-qnorm(wilcox_WOS_NegoResultFollow$p.value/2)
cat("\n# The standardised z statistic Z:")
Zstat_WOS_NegoResultFollow #table 5
cat("\n# The effect size:")
abs(Zstat_WOS_NegoResultFollow)/sqrt(48) #table 5

cat("\n# 2. Training with self-motivation\n") 
wilcox_WS_NegoResultFollow<-wilcox.test(NegoResult_AllWS$FollowUp,NegoResult_AllWS$Pre,paired=TRUE)
cat("\n# p value:")
wilcox_WS_NegoResultFollow$p.value
Zstat_WS_NegoResultFollow<-qnorm(wilcox_WS_NegoResultFollow$p.value/2)
cat("\n# The standardised z statistic Z:")
Zstat_WS_NegoResultFollow
cat("\n# The effect size:")
abs(Zstat_WS_NegoResultFollow)/sqrt(48)

cat("\n# 3. Training with self-motivation VS Training without self-motivation\n")
NegoResult_WSChange_follow<-NegoResult_AllWS$FollowUp-NegoResult_AllWS$Pre
NegoResult_WOSChange_follow<-NegoResult_AllWOS$FollowUp-NegoResult_AllWOS$Pre
g = factor(c(rep("NegoResult_WSChange_follow", length(NegoResult_WSChange_follow)), rep("NegoResult_WOSChange_follow", length(NegoResult_WOSChange_follow))))
v = c(NegoResult_WSChange_follow, NegoResult_WOSChange_follow)
wilcox_test(v~g,distribution="exact")
wilcox_comparefollow_NegoResult<-wilcox_test(v~g,distribution="exact")
cat("\n# p value:")
pvalue(wilcox_comparefollow_NegoResult) #table 3
cat("\n# The standardised z statistic Z:")
Zstat_comparefollow_NegoResult<-wilcox_comparefollow_NegoResult@statistic@teststatistic[["NegoResult_WOSChange_follow"]]#table 3
Zstat_comparefollow_NegoResult
cat("\n# The effect size:")
abs(Zstat_comparefollow_NegoResult)/sqrt(48) #table 4


cat("\n#################### refer to 5.2 Training session ####################\n")
cat("\n###### Multilevel analysis of self-efficacy across the training sessions ######\n")
cat("\n###### refer to table 6: Multilevel analysis results of self-efficacy across the training sessions. ###### \n")
SE_Intervetion<-subset(SE_AllFormalized, Session !="SE")
Model1 <- lme (Score ~ 1, random= ~1|ID, data =SE_Intervetion,method = "ML",na.action=na.exclude)
Model2 <- lme (Score ~ Session, random= ~1|ID, data =SE_Intervetion,method = "ML", na.action=na.exclude)
Model3 <- lme (Score ~ Session + Group, random= ~1|ID, data =SE_Intervetion,method = "ML", na.action=na.exclude )
Model4 <- lme (Score ~ Session + Group + Group:Session, random= ~1|ID, data =SE_Intervetion,method = "ML" , na.action=na.exclude)
Model5 <- lme (Score ~ Session + Group:Session, random= ~1|ID, data =SE_Intervetion,method = "ML" , na.action=na.exclude)
anova(Model1, Model2, Model3, Model4) #table 6
anova(Model2, Model4) 
intervals(Model1,0.95) #table 6
summary(Model2)


cat("\n#################### refer to 5.3 Perceived utility ####################\n")

cat("\n#1 Satisfaction related utility\n") 
Utility_Satisfaction$Score<-rowMeans(Utility_Satisfaction[2:4])
describe(Utility_Satisfaction$Score) # text
t.test(Utility_Satisfaction$Score,mu=4) # text

cat("\n#1 Effectiveness related utility\n") 
Utility_Effectiveness$Score<-rowMeans(Utility_Effectiveness[2:5])
describe(Utility_Effectiveness$Score) # text
t.test(Utility_Effectiveness$Score,mu=4) # text

Utility_SatisfactionSub<-Utility_Satisfaction[,c(1,5:6)]
Utility_EffectivenessSub<-Utility_Effectiveness[,c(1,6:7)]
Utility_Satisfaction_WS<-subset(Utility_Satisfaction, Group=="WS")
Utility_Satisfaction_WOS<-subset(Utility_Satisfaction, Group=="WOS")
Utility_Effectiveness_WS<-subset(Utility_Effectiveness, Group=="WS")
Utility_Effectiveness_WOS<-subset(Utility_Effectiveness, Group=="WOS")
cat("\n#Compare the utility data of participants from training with self-motivation and without self-motivation.\n") 
testbetween(Utility_Satisfaction_WS$Score,Utility_Satisfaction_WOS$Score)
testbetween(Utility_Effectiveness_WS$Score,Utility_Effectiveness_WOS$Score)

######### stop redireting output.
sink()
cat("\nOutput of the analysis can be found back in file output_analysisII_MainResults.txt")